# python 2.1 compatibility
try:
  True == True
except:
  True = 1
  False = 0

class IACASUserFolder:
    """
    Interface designed to be used from DTML and ZPT
    to access ACAS User Folder  -public-  methods.

    Note:
        cas_redirect_to_login() is not usefull if the auto_redirect
        feature of ACASUserFolder is activated.
    """
    
    def cas_get_username(self, REQUEST = None):
        """
        Returns a string which is a user login.
        This user CAS ticket was validated from the CAS server.
        It requires a logged-in user context.
        Otherwise returns None.
        """
        raise NotImplementedError

    def cas_redirect_to_login(self, REQUEST = None, force = False):
        """
        Cause the client browser to be redirected to the
        CAS login page and then to come back to the very same
        page it came from with a CAS ticket (if password OK)
        If the ticket is valid, then the user will be authenticated
        for the second page loading.

        With this call, the current request is not seen by the client browser.

        if Force is true, then redirect will use lock
        """
        raise NotImplementedError

    def cas_complete_logout(self, REQUEST = None, service = None):
        """
        Clean local CAS credentials AND CASTGC secure cookie which
        is the -global- credential.
        To achieve this, the client browser will be redirected to the
        CAS server to clear the cookie and CAS server side credentials, 
        then it will come back to this very same page (if service is None)
        but Anonymously.

        service is the url to which the client will be redirected to after
        logging out from the CAS server.
        """
        raise NotImplementedError

    def cas_local_logout(self, REQUEST = None, service = None):
        """
        Logout only from the Zope server.
        Be aware that within frames or when loading images, other parts may 
        be viewed anonymously depending on the browser loading order.
        If service is provided, then the client is redirected to <service>
        URL. This allow to draw the page in Anonymous mode rather than having
        a clumsy page with a connected context while next request will be
        anonymous.

        service is an URL like in cas_complete_logout
        """
        raise NotImplementedError


        
