
from HTMLParser import HTMLParser
class CASXMLResponseParser(HTMLParser):
    """
    Class used to parse XML response from CAS server.
    It currently works with cas server 2.0.12 from yale.

    it works by raising two types of exceptions :
        - "user", username
        - "failure", failure_message
    """
    _user = 0
    _failure = 0

    def handle_starttag(self, tag, attrs):
        # tag is returned lowercase
        if tag == 'cas:user' or tag == 'user':
            self._user = 1
        if tag == 'cas:authenticationfailure' or tag == 'authenticationfailure':
            self._failure = 1

    def handle_data(self, data):
        if self._user == 1:
            raise "user", data
        if self._failure == 1:
            raise "failure", data

    def handle_endtag(self, tag):
            pass




