# General Python imports
import unittest
import base64
from cStringIO import StringIO
from UserDict import UserDict

# Zope packages
from Testing import makerequest
from Acquisition import Implicit
import AccessControl.User
import Products.Sessions
import ZPublisher.BaseRequest
from OFS.Folder import Folder
from OFS.SimpleItem import Item # Basic zope object
from ZPublisher.HTTPRequest import HTTPRequest
from ZPublisher.HTTPResponse import HTTPResponse

# ACASUserFolder package imports
import ACASUserFolder
import UserStorage
import ProtectedSessionInfo

sdm_name = 'session_data_manager'

class DummySessionDataManager(Item):

    def __init__(self, hasSD = False):
        self._hasSD = hasSD
    
    def hasSessionData(self):
        return self._hasSD

def mkrequest(root, stdout, stdin=None):
    # Customized version of Testing.makerequest.makerequest()
    resp = HTTPResponse(stdout=stdout)
    environ = {}
    environ['SERVER_NAME'] = 'example.com'
    environ['SERVER_PORT'] = '80'
    environ['REQUEST_METHOD'] = 'GET'
    if stdin is None:
        stdin = StringIO('')  # Empty input
    req = HTTPRequest(stdin, environ, resp)
    req['PARENTS'] = [root]

    sess = UserDict()
    sess.set = sess.__setitem__
    req.SESSION = sess
    
    return req


def mkDummySessionAwareApp():
    f = Folder()
    f.isTopLevelPrincipiaApplicationObject = 1  # User folder needs this
    f.getPhysicalPath = lambda: ()  # hack
    f._View_Permission = ('Anonymous',)

    sdm = DummySessionDataManager(hasSD = True)
    f._setObject(sdm_name, sdm)
    
    f.responseOut = StringIO()
    req = mkrequest(f, f.responseOut)
    f.REQUEST = req
    #f._setObject('REQUEST', req)

    return f

def addCUF(app, persistent_users):
    cuf = ACASUserFolder.ACASUserFolder(
        login_url = "http://the.cas.server/login", 
	validate_url = "http://the.cas.server/serviceValidate", 
        logout_url = "http://the.cas.server/logout", 
	default_roles = ['Anonymous'], 
	auto_redirect=False, 
	persistent_users = persistent_users,
	REQUEST=None)
    app._setObject(cuf.getId(), cuf) # acl_users
    return app.acl_users # wrapped
	    







class USTest(unittest.TestCase):

    def setUp(self):
        #import Zope
	#from Testing import makerequest
	#self.app = makerequest.makerequest(Zope.app())
	pass
	
    def testSecure(self):
        app = mkDummySessionAwareApp()
	cuf = addCUF(app, True)
	pus = cuf.user_storage

        REQUEST = app.REQUEST
	pus._setSecure(REQUEST, 'the_key', 'the_value')
	assert pus._getSecure(REQUEST, 'the_key') == 'the_value'

	assert pus._delPSI(REQUEST) == True
	assert pus._delPSI(REQUEST) == False

    def testPUS(self):
        p_app = mkDummySessionAwareApp()
	p_cuf = addCUF(p_app, True)
        pus = p_cuf.user_storage

	assert pus.getUsers() == []
	assert pus.getUserNames() == []
	assert pus.getUser('BANG!!!') is None
	user1 = AccessControl.User.SimpleUser('rastapopoulos', 'pass', [], [])
	user2 = AccessControl.User.SimpleUser('rastapopoulos2', 'pass2', [], [])
	pus.addUser('rastapopoulos', user1)
	pus.addUser('rastapopoulos2', user2)
	assert pus.getUser('rastapopoulos') is user1
	assert len(pus.getUsers()) == 2
	pus.delUsers(['rastapopoulos'])
	assert pus.getUser('rastapopoulos') is None
	assert len(pus.getUsers()) == 1
	pus.delUsers(['rastapopoulos2'])
	assert len(pus.getUsers()) == 0
	

    def testSUS(self):
        v_app = mkDummySessionAwareApp()
	v_cuf = addCUF(v_app, False)
        pus = v_cuf.user_storage
	REQUEST = v_app.REQUEST
	
	assert pus.getUsers() == []
	assert pus.getUserNames() == []
	assert pus.getUser('BANG!!!') is None
	user1 = AccessControl.User.SimpleUser('rastapopoulos', 'pass', [], [])
	user2 = AccessControl.User.SimpleUser('rastapopoulos2', 'pass2', [], [])
	pus.addUser('rastapopoulos', user1)
	pus.addUser('rastapopoulos2', user2)
	assert pus.getUser('rastapopoulos2') is user2
	assert len(pus.getUsers()) == 1
	pus.delUsers(['rastapopoulos2'])
	assert pus.getUser('rastapopoulos2') is None
	assert len(pus.getUsers()) == 0
	pus.delUsers([])
	assert len(pus.getUsers()) == 0
	pus.setTicketValidatedUserName(REQUEST, 'trueman')
	assert pus.getTicketValidatedUserName(REQUEST) == 'trueman'
	pus.ticketUnvalidateUserName(REQUEST)
	assert pus.getTicketValidatedUserName(REQUEST) is None






class CUFTest(unittest.TestCase):

    def setUp(self):
	pass

    
    def testIACASUserFolder(self):
        p_app = mkDummySessionAwareApp()
	p_cuf = addCUF(p_app, True)
	
	# cas_get_username()
	p_cuf.user_storage.setTicketValidatedUserName(p_cuf.REQUEST, 'droopy')
	assert p_cuf.cas_get_username() == 'droopy'

        # cas_local_logout()
        p_cuf.cas_local_logout()
	assert p_cuf.cas_get_username() is None

        # cas_redirect_to_login() # syntax check only
	p_cuf.cas_redirect_to_login(force = True)

   	# cas_complete_logout() # one part is syntax check
	p_cuf.user_storage.setTicketValidatedUserName(p_cuf.REQUEST, 'wolf')
	assert p_cuf.cas_get_username() == 'wolf'
	p_cuf.cas_complete_logout()
	assert  p_cuf.cas_get_username() is None

    def testBasicUserFolder(self):
        p_app = mkDummySessionAwareApp()
	p_cuf = addCUF(p_app, True)

        v_app = mkDummySessionAwareApp()
	v_cuf = addCUF(v_app, False)
	
	# by default folders are empty
	assert p_cuf.getUsers() == []
	assert v_cuf.getUsers() == []

	assert p_cuf.getUser('ajrarn') is None
	assert v_cuf.getUser('ajrarn') is None
	p_cuf._doAddUser('ajrarn', 'pwd_unused', p_cuf.cuf_default_roles, p_cuf.cuf_default_domains)
	v_cuf._doAddUser('ajrarn', 'pwd_unused', v_cuf.cuf_default_roles, v_cuf.cuf_default_domains)

	assert p_cuf.getUserNames() == [ 'ajrarn' ]
	assert v_cuf.getUserNames() == [ 'ajrarn' ]

	assert p_cuf.hasUsers() == v_cuf.hasUsers() == True

	roles = ['Prince des demons']
	domains = ['la nuit', 'Druhim Vanashta']
	p_cuf._doChangeUser('ajrarn', 'night_pass', roles, domains)
	user = p_cuf.getUser('ajrarn')
	assert user.roles == roles
	assert user.domains == domains
	v_cuf._doChangeUser('ajrarn', 'night_pass', roles, domains)
	user = v_cuf.getUser('ajrarn')
	assert user.roles == roles
	assert user.domains == domains

	p_cuf._doAddUser('chuz', 'strange_pass', ['Prince de la folie'], ['partout et nulle part'])
	v_cuf._doAddUser('chuz', 'strange_pass', ['Prince de la folie'], ['partout et nulle part'])
	assert p_cuf.getUser('chuz').roles == ['Prince de la folie']
	assert v_cuf.getUser('chuz').roles == ['Prince de la folie']
	
	
    def testAuthStuff(self):
        p_app = mkDummySessionAwareApp()
	p_cuf = addCUF(p_app, True)
	
        v_app = mkDummySessionAwareApp()
	v_cuf = addCUF(v_app, True)
	
	# test basic creds
	auth = "Basic %s"%(base64.encodestring("the_user:his_pass"))
	u, p = p_cuf.identify(auth)
	assert (u, p) == ('the_user', 'his_pass')
	u, p = v_cuf.identify(auth)
	assert (u, p) == ('the_user', 'his_pass')

	# test CAS-like identify
	u, p = p_cuf.identify(None)
	assert (u, p) == (ACASUserFolder.ACASUserFolder.CUF_CAS_USERNAME, ACASUserFolder.ACASUserFolder.CUF_CAS_PWD)
	u, p = v_cuf.identify(None)
	assert (u, p) == (ACASUserFolder.ACASUserFolder.CUF_CAS_USERNAME, ACASUserFolder.ACASUserFolder.CUF_CAS_PWD)

	# test basic auth works
	assert p_cuf.authenticate('basic_auth_dummy_name', 'basic_auth_dummy_pwd', p_cuf.REQUEST) == None
	assert v_cuf.authenticate('basic_auth_dummy_name', 'basic_auth_dummy_pwd', v_cuf.REQUEST) == None


    def testCASStuff(self):

	p_app = mkDummySessionAwareApp()
	p_cuf = addCUF(p_app, True)
	
        v_app = mkDummySessionAwareApp()
	v_cuf = addCUF(v_app, True)

	# COMPLEX TEST :
	# simulate a previous CAS identify() + no ticket + previously validated user
	
	p_cuf.user_storage.setTicketValidatedUserName(p_cuf.REQUEST, 'ajrarn')
	authenticate = p_cuf.authenticate(ACASUserFolder.ACASUserFolder.CUF_CAS_USERNAME, 
					  ACASUserFolder.ACASUserFolder.CUF_CAS_PWD, 
					  p_cuf.REQUEST)
	assert authenticate is p_cuf.getUser('ajrarn')

	v_cuf.user_storage.setTicketValidatedUserName(p_cuf.REQUEST, 'ajrarn')
	authenticate = v_cuf.authenticate(ACASUserFolder.ACASUserFolder.CUF_CAS_USERNAME,
					  ACASUserFolder.ACASUserFolder.CUF_CAS_PWD,
					  v_cuf.REQUEST)
	assert authenticate is v_cuf.getUser('ajrarn')
	

    def testPSI(self):
        psi = ProtectedSessionInfo.ProtectedSessionInfo()
        assert not psi._has_key('user_name')
        psi._set('info', 'value')
        assert psi._has_key('info') is not None
        assert psi._get('info') is 'value'
	psi._del('info')
	assert not psi._has_key('info')
	assert psi._get('info') is None
    

def test_suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(USTest))
    suite.addTest(unittest.makeSuite(CUFTest))
    return suite

if __name__ == "__main__":
    unittest.main(defaultTest='test_suite')

