import base64
import re
from urlparse import urlparse
import time
from DateTime import DateTime
from cgi import escape

patt = re.compile(r"(?<!\d)(\d+)(\.0*)?(?!\d)")
valid = re.compile( '^\s*' + '(>|>>|~|<)?\s*(\d+)?(\.\d{0,2})?\s*' + '(-\s*(>|>>|~|<)?(\d+)?(\.\d{0,2})?\s*)?' + '$')

def string_encode(s):
    """ Encodes a string to an ASCII string.
        To be used in the user interface, to avoid problems with the encodings, HTML entities, etc..
    """
    if s:
        if isinstance(s, unicode):
            s = s.encode('utf8')
        return base64.urlsafe_b64encode(s)
    else:
        return s

def string_decode(s):
    """ Decodes a string from an ASCII string.
        To be used in the user interface, to avoid problems with the encodings, HTML entities, etc..
    """
    return base64.urlsafe_b64decode(s)

def parse_semicolon(s, sep='<br />'):
    """ Replaces all semicolons found in the string ${s} with the given separator ${sep}"""
    if s is None:
        return s
    patt = re.compile(r';\s*')
    return patt.sub(sep, s)

def str2num(s, default='N/A'):
    """ check if a string can be represented as integer"""
    if s is None:
        return default
    buffer = str(s)
    if buffer:
        return re.sub(patt, r"\1", buffer)
    else:
        return default

def parse_envelope_url(s):
    """ parse envelope url """
    return urlparse(s)

def how_old(t):
    t = DateTime(t).timeTime()
    #how old is this in hours/days
    td = int(time.time()-t)
    days = int(td/86400)
    if days:
        return {'days': days, 'hours': 0}
    else:
        r = td % 86400;
        hours = int(r/3600)
        return {'days': 0, 'hours': hours}

def get_coordinates(region="/MED/", qstring="/FR|RO|IT/", url="http://merlin.eea.europa.eu/cgi-bin/art17wsQ?%s"):
    """ open url and sort coordinates """
    import urllib
    params = urllib.urlencode({
        'mode':'ITEMNQUERY', 
        'LAYER': 'Europe_BIOGEO_MERGE30Jan', 
        'qlayer': 'Europe_BIOGEO_MERGE30Jan',
        'qitem': 'Country',
        'rg': region,
        'qstring': qstring})
    f = urllib.urlopen(url % params)
    line = f.readline()
    minx, miny, maxx, maxy = line.split()
    for line in f.readlines():
        cur_minx, cur_miny, cur_maxx, cur_maxy = line.split()
        minx = min(minx, cur_minx)
        maxx = max(maxx, cur_maxx)
        miny = min(miny, cur_miny)
        maxy = max(maxy, cur_maxy)
    return [minx, miny, maxx, maxy]

def get_coordinates_noreg(qstring="/FR|RO|IT/", url="http://merlin.eea.europa.eu/cgi-bin/art17wsQ?%s"):
    """ open url and sort coordinates """
    import urllib
    params = urllib.urlencode({
        'mode':'ITEMNQUERY', 
        'LAYER': 'Europe_BIOGEO_MERGE30Jan', 
        'qlayer': 'Europe_BIOGEO_MERGE30Jan',
        'qitem': 'Country',
        'qstring': qstring}) 
    f = urllib.urlopen(url % params)
    line = f.readline()
    print 'line', line, line.split()
    minx, miny, maxx, maxy = line.split()
    for line in f.readlines():
        cur_minx, cur_miny, cur_maxx, cur_maxy = line.split()
        minx = min(minx, cur_minx)
        maxx = max(maxx, cur_maxx)
        miny = min(miny, cur_miny)
        maxy = max(maxy, cur_maxy)
    return [minx, miny, maxx, maxy]





def gen_dict(dict_list, key, value):
    return dict((l[key], l[value]) for l in dict_list)

def linebreaks(value, autoescape=False):
    """Converts newlines into <p> and <br />s."""
    value = re.sub(r'\r\n|\r|\n', '\n', unicode(value, 'utf-8')) # normalize newlines
    paras = re.split('\n{2,}', value)
    if autoescape:
        paras = [u'<p>%s</p>' % escape(p.strip()).replace('\n', '<br />') for p in paras]
    else:
        paras = [u'<p>%s</p>' % p.strip().replace('\n', '<br />') for p in paras]
    return u'\n\n'.join(paras)

def validate_field(s):
    if s:
        return bool(valid.match(s))
    return True

def eval_string(string):
    """ """
    try:
        return eval(string)
    except:
        return {}

def strip_tags(value):
    "Return the given HTML with all tags stripped."
    return re.sub(r'<[^>]*?>', '', value) 
