from PIL import Image
from cStringIO import StringIO 

def generate_thumbnail(picture_data, width = 200, height = 100):
    """
    Generate thumbnail from the given image to specified width and height.
    @param width Width of the resulting thumbnail
    @param height Height of the resulgin thumbnail
    @return A binary string with thumbnail file data
    """
    output = None
    ret = None
    try:
      picture_data.seek(0)
      img = Image.open(picture_data)
      imgCopy = img.copy()
      imgCopy.thumbnail((width, height), Image.ANTIALIAS)
      output = StringIO()
      imgCopy.save(output, img.format)
      output.seek(0)
      ret = output.read()
    finally:
      picture_data.seek(0)
      if output != None:
        output.close()
    return ret
    
    
def console_write(message):
    """
    Write data to zope's console.
    @param message Message to log
    """
    print message
