import urllib
import os, tempfile
from PIL import Image

spc = 'Canis lupus'
class TmpFile:
    def __init__(self, data):
        self.fname = tempfile.mktemp()
        open(self.fname,'w+b').write(data)

    def __str__(self): return self.fname
    __repr__ = __str__

#    def __del__(self):
#        os.unlink(self.fname)

#url = 'http://merlin.eea.europa.eu/cgi-bin/art17wsEU25.py?VERSION=1.1.1&SERVICE=WMS&EXCEPTIONS=application/vnd.ogc.se_xml&EXCEPTIONS=INIMAGE&l=EU25ALP|70A800&l=EU25ATL|B4B4B4&l=EU25BOR|70A800&l=EU25CON|D62B00&l=EU25MED|000000&l=EU25PAN|E69800&method=art17wsEU25.py&REQUEST=GetMap&STYLES=&TRANSPARENT=TRUE&SRS=EPSG:3035&LAYERS=Europe_BIOGEO_MERGE30Jan&FORMAT=PNG&HEIGHT=399&WIDTH=529&BBOX=1981686.09027737,1385857.104555,7180717.84767563,5307244.006638'

def get_url(url):
    f = urllib.urlopen(url)
    return f.read()

def process_image(data, base_image=None):
    image_layer = TmpFile(data)
    img = Image.open(str(image_layer))
    if base_image:
        base_image.paste(img)
        return base_image
    return img


url1 = 'http://merlin.eea.europa.eu/cgi-bin/art17wsBKG?method=art17wsBKG&REQUEST=GetMap&SERVICE=WMS&STYLES=default&TRANSPARENT=TRUE&SRS=EPSG:3035&VERSION=1.1.1&EXCEPTIONS=INIMAGE&LAYERS=Europe_BIOGEO_MERGE30Jan&FORMAT=PNG&HEIGHT=400&WIDTH=530&BBOX=1983283.14634651,1385857.104555,7179120.79160649,5307244.006638'
url2 = 'http://merlin.eea.europa.eu/cgi-bin/art17wsOutline?rg=/^ALP|^ATL|^BOR|^CON|^MED|^PAN/&method=art17wsOutline&REQUEST=GetMap&SERVICE=WMS&STYLES=default&TRANSPARENT=TRUE&SRS=EPSG:3035&VERSION=1.1.1&EXCEPTIONS=INIMAGE&LAYERS=Europe_BIOGEO_MERGE30Jan&FORMAT=PNG&HEIGHT=400&WIDTH=530&BBOX=1983283.14634651,1385857.104555,7179120.79160649,5307244.006638'
url3 = 'http://merlin.eea.europa.eu/cgi-bin/art17wsCountries?method=art17wsCountries&REQUEST=GetMap&SERVICE=WMS&STYLES=&TRANSPARENT=TRUE&SRS=EPSG:3035&VERSION=1.1.1&EXCEPTIONS=INIMAGE&LAYERS=Countries&FORMAT=PNG&HEIGHT=400&WIDTH=530&BBOX=1983283.14634651,1385857.104555,7179120.79160649,5307244.006638'
url4 = 'http://merlin.eea.europa.eu/cgi-bin/art17wsLines?method=art17wsLines&REQUEST=GetMap&SERVICE=WMS&STYLES=default&TRANSPARENT=TRUE&SRS=EPSG:3035&VERSION=1.1.1&EXCEPTIONS=INIMAGE&LAYERS=Art_17_lines&FORMAT=PNG&HEIGHT=400&WIDTH=530&BBOX=1983283.14634651,1385857.104555,7179120.79160649,5307244.006638'
url5 = 'http://merlin.eea.europa.eu/cgi-bin/art17wsEU25.py?VERSION=1.1.1&SERVICE=WMS&EXCEPTIONS=application/vnd.ogc.se_xml&EXCEPTIONS=INIMAGE&l=EU25ALP|70A800&l=EU25ATL|B4B4B4&l=EU25BOR|70A800&l=EU25CON|D62B00&l=EU25MED|000000&l=EU25PAN|E69800&method=art17wsEU25.py&REQUEST=GetMap&STYLES=default&TRANSPARENT=TRUE&SRS=EPSG:3035&LAYERS=Europe_BIOGEO_MERGE30Jan&FORMAT=PNG&HEIGHT=400&WIDTH=530&BBOX=1983283.14634651,1385857.104555,7179120.79160649,5307244.006638'

data = get_url(url1)
base_img = process_image(data)

data = get_url(url2)
base_img = process_image(data, base_img)

data = get_url(url3)
base_img = process_image(data, base_img)

data = get_url(url4)
base_img = process_image(data, base_img)

data = get_url(url5)
base_img = process_image(data, base_img)

file = open('/tmp/final.png' 'w+b').write(base_img)
file.close()

#
#
#http://biodiversity.eionet.europa.eu/article17/upgrade_speciessummary/details/art17ws?method=art17wsBKG&REQUEST=GetMap&SERVICE=WMS&STYLES=default&TRANSPARENT=TRUE&SRS=EPSG:3035&VERSION=1.1.1&EXCEPTIONS=INIMAGE&LAYERS=Europe_BIOGEO_MERGE30Jan&FORMAT=PNG&HEIGHT=377&WIDTH=530&BBOX=1824789.425072,1385857.104555,7337614.512881,5307244.006638
#http://biodiversity.eionet.europa.eu/article17/upgrade_speciessummary/details/art17ws?method=art17wsCountries&REQUEST=GetMap&SERVICE=WMS&STYLES=&TRANSPARENT=TRUE&SRS=EPSG:3035&VERSION=1.1.1&EXCEPTIONS=INIMAGE&LAYERS=Countries&FORMAT=PNG&HEIGHT=377&WIDTH=530&BBOX=1824789.425072,1385857.104555,7337614.512881,5307244.006638
#http://biodiversity.eionet.europa.eu/article17/upgrade_speciessummary/details/art17ws?method=art17wsLines&REQUEST=GetMap&SERVICE=WMS&STYLES=default&TRANSPARENT=TRUE&SRS=EPSG:3035&VERSION=1.1.1&EXCEPTIONS=INIMAGE&LAYERS=Art_17_lines&FORMAT=PNG&HEIGHT=377&WIDTH=530&BBOX=1824789.425072,1385857.104555,7337614.512881,5307244.006638
#http://biodiversity.eionet.europa.eu/article17/upgrade_speciessummary/details/art17ws?VERSION=1.1.1&SERVICE=WMS&SRS=EPSG:4326&SRS=EPSG:3035&EXCEPTIONS=application/vnd.ogc.se_xml&EXCEPTIONS=INIMAGE&spc=%27Canis%20lupus%27&method=art17wsGridDistS&REQUEST=GetMap&STYLES=&TRANSPARENT=TRUE&LAYERS=art_17_Map_Distribution&FORMAT=PNG&HEIGHT=377&WIDTH=530&BBOX=1824789.425072,1385857.104555,7337614.512881,5307244.006638
#http://biodiversity.eionet.europa.eu/article17/upgrade_speciessummary/details/art17ws?VERSION=1.1.1&SERVICE=WMS&SRS=EPSG:4326&SRS=EPSG:3035&EXCEPTIONS=application/vnd.ogc.se_xml&EXCEPTIONS=INIMAGE&spc=%27Canis%20lupus%27&method=art17wsGridRangeS&REQUEST=GetMap&STYLES=&TRANSPARENT=TRUE&LAYERS=Art_17_Map_Range&FORMAT=PNG&HEIGHT=377&WIDTH=530&BBOX=1824789.425072,1385857.104555,7337614.512881,5307244.006638
#http://biodiversity.eionet.europa.eu/article17/upgrade_speciessummary/details/art17ws?VERSION=1.1.1&SERVICE=WMS&EXCEPTIONS=application/vnd.ogc.se_xml&EXCEPTIONS=INIMAGE&l=EU25ALP|70A800&l=EU25ATL|B4B4B4&l=EU25BOR|70A800&l=EU25CON|D62B00&l=EU25MED|000000&l=EU25PAN|E69800&method=art17wsEU25.py&REQUEST=GetMap&STYLES=default&TRANSPARENT=TRUE&SRS=EPSG:3035&LAYERS=Europe_BIOGEO_MERGE30Jan&FORMAT=PNG&HEIGHT=377&WIDTH=530&BBOX=1824789.425072,1385857.104555,7337614.512881,5307244.006638

