

import os
import cgi

########################
# EXAMPLE CODE
########################
#sample url: http://falcon.eea.europa.eu/cgi-bin/art17ws.py?VERSION=1.1.1&SERVICE=WMS&SRS=EPSG:3035&EXCEPTIONS=application/vnd.ogc.se_xml&EXCEPTIONS=INIMAGE&rg=/ALP|ATL|BOR|CON|MED|PAN/&l=CZCON|9CB34D&REQUEST=GetMap&STYLES=&TRANSPARENT=TRUE&LAYERS=Europe_BIOGEO_MERGE30Jan&FORMAT=PNG&HEIGHT=399&WIDTH=529&BBOX=1555410.88968147,1283788.62339,6889766.52311053,5307244.006638

# These take effect in process space. You'll get weird results if you change them dynamically
os.environ['PROJ_LIB'] = '/usr/share/proj'
os.environ['MS_MAPFILE'] = '/var/local/GIS/mapserver_maps/art17species.map'

def HTMLColorToRGB(colour):
    """ convert #RRGGBB to an (R, G, B) tuple """
    colour = colour.strip()
    if colour[0] == '#': colour = colour[1:]
    if len(colour) != 6:
        logger.error("Input #%s is not in #RRGGBB format" % colour)
    r, g, b = colour[:2], colour[2:4], colour[4:]
    r, g, b = [int(n, 16) for n in (r, g, b)]
    return "COLOR+%s+%s+%s" % (r, g, b)

def art17ws(self):
    REQUEST = self.REQUEST
    RESPONSE = REQUEST.RESPONSE
    form = cgi.FieldStorage()
    out = {}
    for key in REQUEST.form.keys():  # Yes, there really is a REQUEST.form dict
        if isinstance(form[key], list):
            keys = form[key]
        else:
            keys = [form[key]]
        if key == 'l':
            for c in keys:
                reg, colour = c.value.split('|')
                out['map.layer[0].class[%s].style[0]' % reg] = HTMLColorToRGB(colour)
        else:
            out[key] = keys[0].value

    ret = ["%s=%s" % (k,v) for k, v in out.items()]
    progout = os.popen('/var/www/cgi-bin/mapserv50 "QUERY_STRING=%s"' % '&'.join(ret),'rb')
    while 1:
        data = progout.read(1024)
        if data == '': break        # Will wait until mapserver closes the connection
        RESPONSE.write(data)

    return

