import urllib
import os, tempfile
from cStringIO import StringIO
from PIL import Image
from zipfile import ZipFile
import logging

log = logging.getLogger('art17.map_generator.test')
log.level = logging.DEBUG

def setup_log_handler():
    log_data = StringIO()
    handler = logging.StreamHandler(log_data)
    #handler.setFormatter(logging.Formatter('%(relativeCreated)d %(message)s'))
    log.addHandler(handler)
    return log_data

def get_url(url):
    f = urllib.urlopen(url)
    return f.read()

def compose_map(layers):
    log.info('starting to compose image')
    image = Image.open(StringIO(layers[0]))
    for layer_data in layers[1:]:
        log.info('adding new layer')
        layer_image = Image.open(StringIO(layer_data))
        image.paste(layer_image, None, layer_image)
    log.info('done image')
    return image

def test_compose_map():
    return compose_map([get_url(url) for url in layer_urls])

def zope_dbg(self, REQUEST):
    RESPONSE = REQUEST.RESPONSE
    RESPONSE.setHeader('Content-Type', 'text/plain')
    xml_data = get_layer_urls_from_xml(species='Q2FwcmEgaWJleA==',
        map_type='member_states', map_size='530x400')
    return '\n'.join(xml_data)

def construct_layer_url(layerNode, bbox):
    attrs = dict(layerNode.attributes)
    del attrs['id'], attrs['visible'], attrs['url'], attrs['QUERY_LAYERS']
    url = str(layerNode.getAttribute('url'))
    url = url.replace('art17ws', url.split('=')[-1])
    url = 'http://merlin.eea.europa.eu/cgi-bin/' + url
    q = lambda v: urllib.quote(v.encode('utf-8'))
    for key, value in attrs.iteritems():
        url += '&' + q(key) + '=' + q(value.value)
    url += '&REQUEST=GetMap&TRANSPARENT=TRUE'
    return url

def center_map(data_bbox, width, height):
    xl, yb, xr, yt = map(float, data_bbox.split(','))
    frame_ratio = float(width) / float(height)
    data_ratio = (xr-xl) / (yt-yb)
    if data_ratio > frame_ratio:
        delta = (xr-xl) / frame_ratio - (yt-yb)
        yt += delta/2
        yb -= delta/2
    else:
        delta = (yt-yb) * frame_ratio - (xr-xl)
        xr += delta/2
        xl -= delta/2
    return ','.join(map(str, [xl, yb, xr, yt]))

def get_layer_urls_from_xml(habitat, species, map_type, map_size):
    width, height = map(int, map_size.split('x'))
    base_url = 'http://biodiversity.eionet.europa.eu/article17/'
    if habitat:
        base_url += 'topdf_habitatsummary'
    else:
        base_url += 'topdf_speciessummary'
    config_map = {
        'member_states': base_url + '/details/config_xml',
        'eu25': base_url + '/details/eu25config_xml',
    }
    xml_url = '%s?region=' % (config_map[map_type])
    if habitat:
        xml_url += '&habitat=' + urllib.quote(habitat)
    else:
        xml_url += '&species=' + urllib.quote(species)
    log.info('xml url: %s', xml_url)
    xml = get_url(xml_url)
    xml = xml.strip().replace('&', '&amp;') # our xml documents only have the '&' character as part of URLs, where it should have been escaped
    from xml.dom.minidom import parseString
    dom = parseString(xml)
    bbox = dom.getElementsByTagName('fmc:Map')[0].getAttribute('extent').encode('utf-8')
    log.info('received bounding box: %s', bbox)
    bbox = center_map(bbox, width, height)
    log.info('adjusted bounding box: %s', bbox)
    where =  '&HEIGHT=%d&WIDTH=%d&BBOX=%s' % (height, width, bbox)
    layerNodes = dom.getElementsByTagName('fmc:LayerOGWMS')
    layer_urls = [construct_layer_url(node, bbox) + where for node in layerNodes if node.getAttribute('visible') == 'True']
    layer_urls.reverse()
    output = []
    for layer_url in layer_urls:
        #if 'art_17_Map_Distribution' in layer_url:
        #    continue
        #if 'Art_17_Map_Range' in layer_url:
        #    continue
        output.append(layer_url)
    return output

def get_layers_as_zipfile(layer_urls):
    s = StringIO()
    z = ZipFile(s, 'w')
    c = 0
    for url in layer_urls:
        c += 1
        z.writestr(str(c)+'.png', get_url(url))
    z.close()
    return s.getvalue()

def get_map_image(habitat, species, map_type, map_size):
    log_data = setup_log_handler()
    log.info('getting the xml')
    layer_urls = get_layer_urls_from_xml(habitat, species, map_type, map_size)
    #return (log_data.getvalue(), 'text/plain')
    if False:
        z = get_layers_as_zipfile(layer_urls)
        return (z, 'application/octet-stream')
    else:
        for layer_url in layer_urls:
            log.info('layer URL: %s', layer_url)
        #layer_urls = layer_urls[0:1] + layer_urls[-1:]
        #return (log_data.getvalue(), 'text/plain')
        #return (get_layers_as_zipfile(layer_urls), 'application/octet-stream')
        log.info('downloading %d layers', len(layer_urls))
        layers = []
        for layer_url in layer_urls:
            layer_data = get_url(layer_url)
            log.info('got layer %s (%d)', layer_url, len(layer_data))
            layers.append(layer_data)
        image = compose_map(layers)
        data = StringIO()
        image.save(data, 'png')
        return (data.getvalue(), 'image/png')

def zope_get_map_image(self, REQUEST, map_type, map_size, species=None, habitat=None):
    data, content_type = get_map_image(habitat, species, map_type, map_size)
    resp = REQUEST.RESPONSE
    resp.setHeader('Content-Type', content_type)
    resp.write(data)

if __name__ == '__main__':
    import sys
    species, map_type, map_size = sys.argv[1:4]
    #layer_urls = get_layer_urls_from_xml(species, map_type)
    #image = compose_map(map(get_url, layer_urls))
    #data = StringIO()
    #image.save(data, 'png')
    #print data
    print get_map_image(species, map_type, map_size)[0]
