<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:UML="org.omg/standards/UML">

<xsl:template match="umlobjects">
<html>
    <head>
            <title>Class descriptions</title>
    </head>
    <body>
            <h1>Class descriptions</h1>
                    <xsl:apply-templates select="UML:Class" />
    </body>
</html>
</xsl:template>

<xsl:template match="UML:Class">
        <h2><xsl:value-of select="@name" /> (<xsl:value-of select="@package" />)</h2>
        <p><xsl:value-of select="@documentation" /></p>
        <table border="1" width="500">
        <tr><th colspan="2">Attributes</th></tr>
                <xsl:apply-templates select="UML:Attribute" />
        <tr><th colspan="2">Operations</th></tr>
                <xsl:apply-templates select="UML:Operation" />
        </table>
</xsl:template>

<xsl:template match="UML:Attribute">
  <tr>
    <td><xsl:value-of select="@name" /></td>
    <td><xsl:value-of select="@documentation" /></td>
  </tr>
</xsl:template>

<xsl:template match="UML:Operation">
  <tr>
    <td><xsl:value-of select="@name" /></td>
    <td><xsl:value-of select="@documentation" /></td>
  </tr>
</xsl:template>

<xsl:template match="text()">
</xsl:template>

</xsl:stylesheet>
