# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is SmallObligations version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel Romania are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Soren Roug, EEA
# Miruna Badescu, Finsiel Romania

__doc__='''Small Obligations Product Initialization
$Id$'''

import SmallObligationFolder
import SmallLocalityFolder
from App.ImageFile import ImageFile

def initialize(context):
    """ SmallObligations """

    # Folder for the Small Localities
    context.registerClass(
        SmallLocalityFolder.SmallLocalityFolder,
        constructors=(SmallLocalityFolder.manage_addLocalityFolderForm,
                       SmallLocalityFolder.manage_addLocalityFolder),
        icon='www/localityFolder.gif',
        )

    # Folder for the Small Obligations
    context.registerClass(
        SmallObligationFolder.SmallObligationFolder,
        constructors=(SmallObligationFolder.manage_addObligationFolderForm,
                       SmallObligationFolder.manage_addObligationFolder),
        icon='www/obligationFolder.gif',
        )

    context.registerHelp()
    context.registerHelpTitle('Zope Help')

misc_ = {
    "obligation.gif":   ImageFile("www/obligation.gif", globals()),
    "locality.gif":     ImageFile("www/locality.gif", globals())
}
