# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is SmallObligations version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel Romania are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Soren Roug, EEA
# Miruna Badescu, Finsiel Romania

""" SmallObligationFolder object
    Container for SmallObligation objects
"""

# Zope imports
from Products.ZCatalog.CatalogAwareness import CatalogAware
from Globals import DTMLFile, MessageDialog, InitializeClass
from AccessControl import getSecurityManager, ClassSecurityInfo
from OFS.Folder import Folder
from OFS.FindSupport import FindSupport
import MimeWriter
import mimetools
import cStringIO
import smtplib

# product imports
import SmallObligation

manage_addObligationFolderForm=DTMLFile('dtml/ObligationFolder_add', globals())

def manage_addObligationFolder(self, id, title, SMTP_Host, SMTP_Port=25, REQUEST=None):
    """ Adds a new SmallLocalityFolder object """

    ob = SmallObligationFolder(id, title, SMTP_Host, SMTP_Port)
    self._setObject(id, ob)

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)

class SmallObligationFolder( CatalogAware, Folder ):
    """
    Small Obligation Folder object
    """
    meta_type='Small Obligation Folder'

    # Create a SecurityInfo for this class. We will use this
    # in the rest of our class definition to make security
    # assertions.
    security = ClassSecurityInfo()

    # All folder tabs but 'View'
    manage_options = (Folder.manage_options[0],) + \
            ({'label':'View', 'action':'index_html'}, ) + \
            Folder.manage_options[2:]

    def all_meta_types( self, interfaces=None ):
        """ Supported meta types
        """
        y = [  {'name': 'Small Obligation', 'action': 'manage_addObligationForm'} ]
        return y

    _properties = ({'id':'title', 'type':'string', 'mode':'w'},
        {'id':'SMTP_Host', 'type':'string', 'mode':'w'},
        {'id':'SMTP_Port', 'type':'string', 'mode':'w'},
    )

    def __init__(self, id, title, SMTP_Host, SMTP_Port=25):
        """ SmallObligationFolder constructor """
        self.id = id
        self.title = title
        self.SMTP_Host = SMTP_Host
        self.SMTP_Port = SMTP_Port

    security.declareProtected('View', 'list_obligations')
    def list_obligations(self):
        """ Returns a list of dictionaries - obligations 
            To be called via XML-RPC
        """
        l_obligations = []

        for obligation in self.objectValues('Small Obligation'):
            l_dict = {}
            l_dict['name'] = obligation.title_or_id() # For DISMED
            l_dict['inx'] = obligation.getId()  # For DISMED
            l_dict['TITLE'] = obligation.title_or_id()
            l_dict['SOURCE_TITLE'] = self.title_or_id()
            l_dict['PK_SOURCE_ID'] = self.absolute_url()
            l_dict['PK_RA_ID'] = obligation.getId()
            l_dict['details_url'] = obligation.global_uri()
            l_dict['uri'] = obligation.global_uri()
            l_dict['terminated'] = str(obligation.terminated)
            l_obligations.append(l_dict)
        
        return l_obligations

    security.declareProtected('View', 'index_html')
    index_html = DTMLFile('dtml/ObligationFolder_view', globals())

    security.declareProtected('View', 'obligations_rdf')
    obligations_rdf = DTMLFile('dtml/ObligationFolder_rdf', globals())

    manage_addObligationForm = SmallObligation.manage_addObligationForm
    manage_addObligation = SmallObligation.manage_addObligation

    def CreateEmail(self, eContent, eTo, eFrom, eSubject):
        """Create a mime-message that will render as text"""

        out = cStringIO.StringIO() # output buffer for our message
        writer = MimeWriter.MimeWriter(out)

        # set up some basic headers
        writer.addheader("From", eFrom)
        writer.addheader("To", eTo)
        writer.addheader("Subject", eSubject)
        writer.addheader("MIME-Version", "1.0")
        writer.addheader("Date", time.strftime("%a, %d %b %Y %H:%M:%S +0000", time.gmtime()))

        # start the multipart section of the message
        try:
            writer.startmultipartbody("alternative")
        except:
            timestamp = '%.3f' % time.time()
            seed = `random.randint(0, 32767)`
            writer._boundary =  '1.1.1.1.1.1.1.' + timestamp + '.' + seed
            writer.startbody("multipart/alternative", [("boundary", writer._boundary)], 1)

        writer.flushheaders()

        # the plain text section
        subpart = writer.nextpart()
        pout = subpart.startbody("text/plain", [("charset", 'iso-8859-1')])
        pout.write(eContent)

        #close your writer and return the message body
        writer.lastpart()
        msg = out.getvalue()
        out.close()
        return msg

    security.declarePublic('SendEmail')
    def SendEmail(self, eContent, eTo, eFrom, eSubject):
        """Sends an email"""
        message = CreateEmail(eContent, eTo, eFrom, eSubject)
        server = smtplib.SMTP(self.SMTP_Host, self.SMTP_Host)
        server.sendmail(eFrom, eTo, message)
        server.quit()
        return 1

InitializeClass(SmallObligationFolder)
