# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is SmallObligations version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel Romania are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Soren Roug, EEA
# Miruna Badescu, Finsiel Romania

""" SmallObligation object
"""

from Products.ZCatalog.CatalogAwareness import CatalogAware
from OFS.SimpleItem import SimpleItem
from Globals import DTMLFile, MessageDialog, InitializeClass
from AccessControl import getSecurityManager, ClassSecurityInfo
from AccessControl.Role import RoleManager

manage_addObligationForm=DTMLFile('dtml/Obligation_add', globals())
def manage_addObligation(self, id, title='', localities_list=[], description='',
        requester='', foreignuri='', REQUEST=None):
    """Add a new Obligation object """

    ob = SmallObligation(id, title, localities_list, description, requester,foreignuri)
    self._setObject(id, ob)

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)

class SmallObligation(
    CatalogAware,
    SimpleItem
    ):
    """ SmallObligation object
    """
    meta_type='Small Obligation'
    icon = 'misc_/SmallObligations/obligation.gif'

    # Create a SecurityInfo for this class. We will use this
    # in the rest of our class definition to make security
    # assertions.
    security = ClassSecurityInfo()

    manage_options=( 
	{'label':'Properties', 'action':'manage_main'},
	{'label':'View', 'action':'index_html'}, ) + \
        SimpleItem.manage_options

    def __init__(self, id, title='', localities_list=[], description='',
            requester='', foreignuri=''):
        """ Obligation constructor
        """
        self.id = id
        self.title = title
        self.localities_list = localities_list
        self.description = description
        self.requester = requester
        self.foreignuri = foreignuri
        self.terminated = 0

    def __setstate__(self, state):
        """ update """
        SmallObligation.inheritedAttribute('__setstate__')(self, state)
        if not hasattr(self, 'localities_list'):
            if 'localities' in self.propertyIds():
                self.localities_list = self.getProperty('localities')
            else:
                self.localities_list = []

        if not hasattr(self,'foreignuri'):
            self.foreignuri = ''

        if not hasattr(self,'terminated'):  # New in version 1.2
            self.terminated = 0

    # Default view
    security.declareProtected('View', 'index_html')
    index_html=DTMLFile('dtml/Obligation_view',globals())

    # Manage properties
    security.declareProtected('View management screens', 'manage_main')
    manage_main = DTMLFile('dtml/Obligation_edit',globals())

    security.declareProtected('Change Small Obligations', 'manage_editObligation')
    def manage_editObligation(self, title, description, requester,
            foreignuri, localities_list=[], terminated=0, REQUEST=None):
        """ Manage the edited values """
        self.title = title
        self.localities_list = localities_list
        self.description = description
        self.requester = requester
        self.foreignuri = foreignuri
        self.terminated = terminated
        self.reindex_object()

        if REQUEST is not None:
            return MessageDialog(
                title = 'Edited',
                message = "The properties of %s have been changed!" % self.id,
                action = './manage_main',
            )

    def email_notifications(self):
        """ Sends email notifications
        """
        l_Subject = 'Notification for Reporting Obligation'
        l_Content = 'The obligation ' + self.title_or_id()
        # list of the addresses (responsibles property) from all
        # Small Locality objects this obligation refers to
        l_To = ''
        # to define what this address is...
        l_From = self.requester
        SendEmail(l_Content, l_To, l_From, l_Subject)

    security.declarePublic('global_uri')
    def global_uri(self):
        """ Returns the globally unique uri for this object
        """
        if self.foreignuri == '':
            return self.absolute_url()
        else:
            return self.foreignuri

InitializeClass(SmallObligation)
