# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is SmallObligations version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel Romania are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Soren Roug, EEA
# Miruna Badescu, Finsiel Romania

""" SmallLocalityFolder object
    Container for SmallLocality objects
"""

# Zope imports
from Products.ZCatalog.CatalogAwareness import CatalogAware
from Globals import DTMLFile, MessageDialog, InitializeClass
from AccessControl import getSecurityManager, ClassSecurityInfo
from OFS.Folder import Folder

# product imports
import SmallLocality

def listsort(s1,s2):
    if s1['name'] > s2['name']:
        return 1
    elif s1['name'] < s2['name']:
        return -1
    else:
        return 0

manage_addLocalityFolderForm=DTMLFile('dtml/LocalityFolder_add', globals())

def manage_addLocalityFolder(self, id, title, REQUEST=None):
    """ Adds a new SmallLocalityFolder object """

    ob = SmallLocalityFolder(id, title)
    self._setObject(id, ob)

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)

class SmallLocalityFolder( CatalogAware, Folder ):
    """ SmallLocalityFolder """
    meta_type='Small Locality Folder'

    # Create a SecurityInfo for this class. We will use this
    # in the rest of our class definition to make security
    # assertions.
    security = ClassSecurityInfo()

    # All folder tabs but 'View'
    manage_options = (Folder.manage_options[0],) + \
            ({'label':'View', 'action':'index_html'}, ) + \
            Folder.manage_options[2:]

    def all_meta_types( self, interfaces=None ):
        """ Supported meta_types
        """
        y = [  {'name': 'Small Locality', 'action': 'manage_addLocalityForm'} ]
        return y

    _properties = ({'id':'title', 'type':'string', 'mode':'w'},
    )

    def __init__(self, id, title=''):
        """ Locality constructor """
        self.id = id
        self.title = title
    
    security.declareProtected('View', 'list_localities')
    def list_localities(self):
        """ Returns a list localities 
            To be called via XML-RPC
        """
        l_localities = []

        for locality in self.objectValues('Small Locality'):
            l_dict = {}
            l_dict['iso'] = locality.getId()
	    l_dict['uri'] = locality.global_uri()
            l_dict['name'] = locality.title_or_id()
            l_localities.append(l_dict)
        
        l_localities.sort(listsort)
        return l_localities

    security.declareProtected('View', 'index_html')
    index_html = DTMLFile('dtml/LocalityFolder_view', globals())

    security.declareProtected('View', 'localities_rdf')
    localities_rdf = DTMLFile('dtml/LocalityFolder_rdf', globals())

    manage_addLocalityForm = SmallLocality.manage_addLocalityForm
    manage_addLocality = SmallLocality.manage_addLocality

InitializeClass(SmallLocalityFolder)
