# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is SmallObligations version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel Romania are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Soren Roug, EEA
# Miruna Badescu, Finsiel Romania

""" SmallLocality object
"""

from Products.ZCatalog.CatalogAwareness import CatalogAware
from OFS.SimpleItem import SimpleItem
from OFS.PropertyManager import PropertyManager
from Globals import DTMLFile, MessageDialog, InitializeClass
from AccessControl import getSecurityManager, ClassSecurityInfo

manage_addLocalityForm=DTMLFile('dtml/Locality_add', globals())

def manage_addLocality(self, id, title='', responsibles=[], foreignuri='', REQUEST=None):
    """Add a new Small Locality object """

    ob = SmallLocality(id, title, responsibles, foreignuri)
    self._setObject(id, ob)

    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)

class SmallLocality(CatalogAware, 
        SimpleItem, 
        PropertyManager
        ):
    """ SmallLocality objects
    """
    meta_type='Small Locality'
    icon = 'misc_/SmallObligations/locality.gif'

    # Create a SecurityInfo for this class. We will use this
    # in the rest of our class definition to make security
    # assertions.
    security = ClassSecurityInfo()

    manage_options=PropertyManager.manage_options + \
        ( {'label':'View', 'action':'index_html'}, ) + \
        SimpleItem.manage_options

    _properties = (
        {'id':'title', 'type':'string', 'mode':'w'},
        {'id':'responsibles', 'type':'lines', 'mode':'w'},
        {'id':'foreignuri', 'type':'string', 'mode':'w'},
    )

    def __init__(self, id, title='', responsibles=[], foreignuri=''):
        """ Locality constructor """
        self.id = id
        self.title = title
        self.responsibles = responsibles
        self.foreignuri = foreignuri

    def __setstate__(self,state):
        SmallLocality.inheritedAttribute('__setstate__')(self, state)

        if not hasattr(self,'foreignuri'):
            self.foreignuri = ''

    # Default view
    security.declareProtected('View', 'index_html')
    index_html = DTMLFile('dtml/Locality_view',globals())

    security.declarePublic('global_uri')
    def global_uri(self):
        """ Returns the globally unique uri for this object
        """
	if self.foreignuri == '':
	    return self.absolute_url()
	else:
	    return self.foreignuri

InitializeClass(SmallLocality)
