#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

import unittest, os
from os.path import join
from GML.shp_to_gml import shp_to_gml

# There is a bug in constants.py, which means you can only provide full path names (sic)
cwd = os.getcwd()

schema_loc = "http://biodiversity.eionet.europa.eu/schemas/dir9243eec/habitatsandspecies.xsd"

class TestSimple(unittest.TestCase):
    
#   def setUp(self):
#       pass

#   def tearDown(self):
#       pass
        
    def test_FR_distMap(self):
        filename = join(cwd, "shape","FR_distMap")
        res = shp_to_gml(filename, schema_loc)
        lookfor = """
<gml:FeatureCollection
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
xsi:noNamespaceSchemaLocation="http://biodiversity.eionet.europa.eu/schemas/dir9243eec/habitatsandspecies.xsd"
xmlns:gml="http://www.opengis.net/gml"
xmlns:met="http://biodiversity.eionet.europa.eu/schemas/dir9243eec">
"""
        assert res.find(lookfor) != -1
        lookfor = """
<gml:boundedBy>
<gml:Envelope>
<gml:coord>
<gml:X>3255838.10827625</gml:X>
<gml:Y>2059508.02394391</gml:Y>
</gml:coord>
<gml:coord>
<gml:X>4279446.90026957</gml:X>
<gml:Y>3129046.80407599</gml:Y>
</gml:coord>
</gml:Envelope>
</gml:boundedBy>
"""
        assert res.find(lookfor) != -1

    def test_point_cities(self):
        filename = join(cwd, "shape","point_cities")
        res = shp_to_gml(filename, schema_loc)
        lookfor = """
<gml:boundedBy>
<gml:Envelope>
<gml:coord>
<gml:X>-2349728.37211070</gml:X>
<gml:Y>-1873925.88333319</gml:Y>
</gml:coord>
<gml:coord>
<gml:X>12747908.52151042</gml:X>
<gml:Y>11986838.50912389</gml:Y>
</gml:coord>
</gml:Envelope>
</gml:boundedBy>
"""
        assert res.find(lookfor) != -1
        # Look for the projection
        # FIXME: shp_to_gml only works if the files are in /tmp
        lookfor = """ETRS_1989_LAEA_52N_10E"""
        assert res.find(lookfor) != -1

if __name__ == '__main__':
    unittest.main()
