#!/usr/bin/env python
# -*- coding: utf-8 -*-
#

import unittest, os, StringIO
import zipfile
from os.path import join
from GML.gml_to_shp import gml_to_shp

# There is a bug in constants.py, which means you can only provide full path names (sic)
cwd = os.getcwd()

schema_loc = "http://biodiversity.eionet.europa.eu/schemas/dir9243eec/gml_art17_meta.xsd"

class TestSimple(unittest.TestCase):
    
    def test_Europe(self):
        filename = join(cwd, "gml","Europe.gml")
        res = gml_to_shp(filename, schema_loc)
        zipped_res = StringIO.StringIO(res)
        zf = zipfile.ZipFile(zipped_res)
        self.assertEquals(['Europe.dbf', 'Europe.shp', 'Europe.shx', 'Europe.xml', 'Europe.prj'], zf.namelist())
        zf.close()

    def test_point_cities(self):
        filename = join(cwd, "gml","point_cities.gml")
        res = gml_to_shp(filename, schema_loc)
        zipped_res = StringIO.StringIO(res)
        zf = zipfile.ZipFile(zipped_res)
        self.assertEquals(['point_cities.dbf', 'point_cities.shp',
         'point_cities.shx', 'point_cities.xml', 'point_cities.prj'], zf.namelist())

        #FIXME: Is this the correct name? Shouldn't it be point_cities.shp.xml ?
        metadata = zf.read('point_cities.xml')
        lookfor = "http://biodiversity.eionet.europa.eu/schemas/dir9243eec/gml_art17_meta.xsd"
        assert metadata.find(lookfor) != -1
        zf.close()

    def test_map_distribution_1330(self):
        filename = join(cwd, "gml","map-distribution-1330.gml")
        res = gml_to_shp(filename, schema_loc)
        zipped_res = StringIO.StringIO(res)
        zf = zipfile.ZipFile(zipped_res)
        self.assertEquals(['map-distribution-1330.dbf', 'map-distribution-1330.shp',
         'map-distribution-1330.shx', 'map-distribution-1330.xml', 'map-distribution-1330.prj'], zf.namelist())

        metadata = zf.read('map-distribution-1330.prj')
        lookfor = 'PROJCS["ETRS_1989_LAEA",GEOGCS'
        assert metadata.find(lookfor) != -1
        zf.close()

if __name__ == '__main__':
    unittest.main()
