import os, sys, transaction
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
ZopeTestCase.installProduct('Reportek')
ZopeTestCase.installProduct('PythonScripts')
from configurereportek import ConfigureReportek
from fileuploadmock import FileUploadMock

class FileUploadTest(file):
    __allow_access_to_unprotected_subobjects__=1

    def __init__(self, path, name):
        self.filename = name
        file.__init__(self, path)

class SpreadsheetTestCase(ZopeTestCase.ZopeTestCase, ConfigureReportek):

    def afterSetUp(self):
        self.createStandardDependencies()
        self.createStandardCollection()
        self.assertTrue(hasattr(self.app, 'collection'),'Collection did not get created')
        self.assertNotEqual(self.app.collection, None)
        self.envelope = self.createStandardEnvelope()
        transaction.begin()

    def test_upload_nothing(self):
        """ Check convert_excel_file when no file is uploaded
            The expected result is -1
        """
        res = self.envelope.convert_excel_file('')
        # Test the *effect* of the call.
        self.assertEquals(0, len(self.envelope.objectIds('Report Document')))
        self.assertEquals(-1, res)

    def x_test_convert_text(self):
        """ Create a text document in the envelope and try to convert to XML
            This doesn't work, but the original file is uploaded
            Verify the content_type is text/plain
        """
        myfile = FileUploadMock('C:\\TEMP\\testfile.txt','content here')
        res = self.envelope.convert_excel_file(myfile)
        self.assertEquals(0, res)
        # Test the *effect* of the call.
        document = self.envelope['testfile.txt']
        self.assertEquals('text/plain', document.content_type)

    def test_upload_empty_xml(self):
        """ Check convert_excel_file when an empty template is uploaded
            The conversion works but it doesn't produce XML files
            The original file is uploaded
            Verify the content_type is 'application/vnd.ms-excel'
            The expected result is 0
        """
        myfile = FileUploadMock('C:\\TEMP\\testfile.xml','''<?xml version="1.0" encoding="UTF-8"?>
        <report xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xml:lang="de"
        xsi:noNamespaceSchemaLocation="http://biodiversity.eionet.europa.eu/schemas/dir9243eec/generalreport.xsd">
         </report>''')
        self.envelope.manage_addDocument('testfile.xml', 'Title', myfile)
        document = self.envelope['testfile.xml']
        self.assertEquals('text/xml', document.content_type)

    # The convert_excel_file can't be tested as a unit test. This is because it
    # calls the conversion service by telling it where it can fetch the file.
    # With no webserver launched, this is impossible. It'll have to wait until
    # we push the files to the conversion service with HTTP POST.
    def x_test_upload_empty_excel(self):
        myfile = FileUploadTest('data/Rivers_empty.xls','Rivers_empty.xls')
        res = self.envelope.convert_excel_file(myfile)
        self.assertEquals(0, res)
        document = self.envelope['Rivers_empty.xls']
        self.assertEquals('application/vnd.ms-excel', document.content_type)
        self.assertEquals([], [x for x in self.envelope.objectValues('Report Document') if x.content_type == 'text/xml'])

    # The convert_excel_file can't be tested as a unit test. This is because it
    # calls the conversion service by telling it where it can fetch the file.
    # With no webserver launched, this is impossible. It'll have to wait until
    # we push the files to the conversion service with HTTP POST.
    def x_test_convert_excel(self):
        """ Check convert_excel_file when an correct template is uploaded
            The conversion works and produces XML files in the envelope
            The original file is also uploaded
            Verify the content_type is 'application/vnd.ms-excel'
            The expected result is 1
        """
        myfile = FileUploadTest('data/Rivers_full.xls','Rivers.xls')
        res = self.envelope.convert_excel_file(myfile)
        self.assertEquals(1, res)
        document = self.envelope['Rivers.xls']
        self.assertEquals('application/vnd.ms-excel', document.content_type)
        document = self.envelope['BasicQuality.xml']
        self.assertEquals('text/xml', document.content_type)
        document = self.envelope['ImpactQuality.xml']
        self.assertEquals('text/xml', document.content_type)
        document = self.envelope['ProxyPressures.xml']
        self.assertEquals('text/xml', document.content_type)
        document = self.envelope['Stations.xml']
        self.assertEquals('text/xml', document.content_type)
        #Now try it again to make sure there's no error in deleting old files
        myfile = FileUploadTest('data/Rivers_full.xls','Rivers.xls')
        res = self.envelope.convert_excel_file(myfile)
        self.assertEquals(1, res)
        self.assertEquals(5, len(self.envelope.objectValues('Report Document')))


def test_suite():
    import unittest
    suite = unittest.makeSuite(SpreadsheetTestCase)
    return suite

if __name__ == '__main__':
    framework()

