# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is Reportek version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Miruna Badescu, Finsiel Romania

__doc__ = """
      Container fo mappings between dataflows and types of XML files (XML schemas)
"""

# Zope imports
from OFS.Folder import Folder
from Globals import DTMLFile, InitializeClass
from AccessControl import ClassSecurityInfo
from AccessControl.Permissions import view_management_screens
import Globals

# product imports
import constants
import RepUtils
import DataflowMappingRecord

class DataflowMappings(Folder):
    """ Mappings between dataflows and types of XML files (XML schemas) """

    meta_type = 'Reportek Dataflow Mappings'
    icon = 'misc_/Reportek/datafow_mappings_gif'

    manage_options = ( Folder.manage_options[0], ) + \
        ( {'label':'View', 'action':'dataflowsMappingsView'}, ) + \
        Folder.manage_options[2:] 

    def all_meta_types( self, interfaces=None ):
        """
            What can you put inside me? Checks if the legal products are
            actually installed in Zope
        """
        y = [{'name': 'Reportek Dataflow Mapping Record', 'action': 'manage_addDataflowMappingRecordForm', 'permission': view_management_screens} ]

        return y

    security = ClassSecurityInfo()

    def __init__(self, title=''):
        """ constructor """
        self.id = constants.DATAFLOW_MAPPINGS

    def getEngine(self):
        return getattr(self, constants.ENGINE_ID)

    def getXMLSchemasForDataflow(self, p_dataflow_uri):
        """ returns all the valid schemas for a dataflow """
        return [x.schema_url for x in self.objectValues('Reportek Dataflow Mapping Record') if (x.dataflow_uri == p_dataflow_uri and x.has_webForm)]

    def getXMLSchemasForDataflows(self, p_dataflow_uris):
        """ returns all the valid schemas for multiple dataflows,
            but doesn't check for the existance of XForms for those schemas
        """
        return [x.schema_url for x in self.objectValues('Reportek Dataflow Mapping Record') if x.dataflow_uri in p_dataflow_uris]

    security.declareProtected('Manage OpenFlow', 'dataflowsMappingsView')
    dataflowsMappingsView = DTMLFile('dtml/mapDataflowsSchemasView', globals())

    security.declareProtected(view_management_screens, 'manage_addDataflowMappingRecordForm')
    manage_addDataflowMappingRecordForm = DataflowMappingRecord.manage_addDataflowMappingRecordForm

    security.declareProtected(view_management_screens, 'manage_addDataflowMappingRecord')
    manage_addDataflowMappingRecord = DataflowMappingRecord.manage_addDataflowMappingRecord

    security.declarePublic('dataflows_select')
    dataflows_select = DTMLFile('dtml/dataflows_select', globals())


Globals.InitializeClass(DataflowMappings)
