# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is Reportek version 1.0.
#
# The Initial Developer of the Original Code is European Environment
# Agency (EEA).  Portions created by Finsiel are
# Copyright (C) European Environment Agency.  All
# Rights Reserved.
#
# Contributor(s):
# Miruna Badescu, Finsiel Romania

__doc__ = """
      Mappings between dataflows and types of XML files (XML schemas)
"""

# Zope imports
from OFS.SimpleItem import SimpleItem
from Globals import DTMLFile, InitializeClass
from AccessControl import ClassSecurityInfo
from AccessControl.Permissions import view_management_screens
import Globals

# product imports

manage_addDataflowMappingRecordForm = Globals.DTMLFile('dtml/mapDataflowSchemaAdd', globals())

def manage_addDataflowMappingRecord(self, id, title='', dataflow_uri='', schema_url='', has_webForm=0, REQUEST=None):
    """ add a new converter object """
    ob = DataflowMappingRecord(id, title, dataflow_uri, schema_url, has_webForm)
    self._setObject(id, ob)
    if REQUEST is not None:
        return self.manage_main(self, REQUEST, update_menu=1)

class DataflowMappingRecord(SimpleItem):
    """ Mappings between dataflows and types of XML files (XML schemas) """

    meta_type = 'Reportek Dataflow Mapping Record'
    icon = 'misc_/Reportek/datafow_mappings_gif'

    security = ClassSecurityInfo()

    def __init__(self, id, title='', dataflow_uri='', schema_url='', has_webForm=0):
        """ constructor """
        self.id = id
        self.title = title
        self.dataflow_uri = dataflow_uri
        self.schema_url = schema_url
        self.has_webForm = has_webForm

    manage_options = (
        (
            {'label' : 'Settings', 'action' : 'manage_settings_html'},
        )
        +
        SimpleItem.manage_options
    )

    security.declareProtected(view_management_screens, 'manage_settings')
    def manage_settings(self, title='', dataflow_uri='', schema_url='', has_webForm=0, REQUEST=None):
        """ """
        self.title = title
        self.dataflow_uri = dataflow_uri
        self.schema_url = schema_url
        self.has_webForm = has_webForm
        self._p_changed = 1
        if REQUEST:
            message="Content changed"
            return self.manage_settings_html(self,REQUEST,manage_tabs_message=message)

    def setWebFormAttr(self, hasWF=1):
        """ """
        self.has_webForm = hasWF

    security.declareProtected(view_management_screens, 'manage_settings_html')
    manage_settings_html = Globals.DTMLFile('dtml/mapDataflowSchemaEdit', globals())

    security.declarePublic('dataflows_select')
    dataflows_select = DTMLFile('dtml/dataflows_select', globals())

Globals.InitializeClass(DataflowMappingRecord)
